"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.versioning = void 0;
const MobileAppVersion_model_1 = __importDefault(require("../models/MobileAppVersion.model"));
const versioning = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const mobileAppVersion = yield MobileAppVersion_model_1.default.findOne({
        order: [["createdAt", "DESC"]],
    });
    let mobileVersion = "0.0.0";
    if (mobileAppVersion && mobileAppVersion.version) {
        mobileVersion = mobileAppVersion.version;
    }
    const ENV_VERSION = process.env.VERSION || "ENV VERSION ERROR";
    const APP_VERSION = "1.0.2";
    const LAST_UPDATED = "October 28, 2025 11:30 AM";
    const MOBILE_VERSION = mobileVersion || "0";
    res
        .status(200)
        .json({
        success: true,
        ENV_VERSION,
        APP_VERSION,
        LAST_UPDATED,
        MOBILE_VERSION,
    });
});
exports.versioning = versioning;
