"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateToken = void 0;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const generateToken = (userInfo, isDriverToken = true) => {
    const expiresInValue = "7d";
    const tokenValue = {
        id: userInfo.id,
        parent_id: isDriverToken ? userInfo.logistics_id : userInfo.seller_id,
        isDriverToken,
    };
    const token = jsonwebtoken_1.default.sign(tokenValue, process.env.SECRETKEY || "", {
        expiresIn: expiresInValue,
    });
    return token;
};
exports.generateToken = generateToken;
