"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.multerConfiguration = exports.fileFilter = exports.fileStorage = void 0;
const multer_1 = __importDefault(require("multer"));
const multer_config_1 = require("../configs/multer.config");
const uuid_1 = require("uuid");
const logger_1 = __importDefault(require("./logger"));
exports.fileStorage = multer_1.default.diskStorage({
    destination: (request, file, callback) => {
        let uploadFolder = "";
        const { asset_folder } = request.query;
        if (asset_folder === "delivery") {
            uploadFolder = __dirname + `/../../public_html/img/delivery`;
        }
        else {
            uploadFolder = __dirname + `/../../public_html/uploads`;
        }
        callback(null, uploadFolder);
    },
    filename: (request, file, callback) => {
        const uniqueSuffix = (0, uuid_1.v4)();
        callback(null, uniqueSuffix + "-dr" + file.originalname.replace(/\s+/g, ""));
    },
});
const fileFilter = (request, file, callback) => {
    callback(null, true);
};
exports.fileFilter = fileFilter;
const multerConfiguration = (req, res, next) => {
    const combinedFields = [...multer_config_1.multerFields];
    (0, multer_1.default)({
        storage: exports.fileStorage,
        fileFilter: exports.fileFilter,
        limits: {
            fileSize: 15 * 1024 * 1024,
        },
    }).fields(combinedFields)(req, res, (err) => {
        if (err) {
            logger_1.default.error(`Multer error: ${err.message}`);
            return res.status(400).json({ success: false, message: err.message });
        }
        next();
    });
};
exports.multerConfiguration = multerConfiguration;
