"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setHeadersMiddleware = void 0;
const setHeadersMiddleware = (req, res, next) => {
    res.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, PATCH, DELETE, OPTIONS");
    const requestHeaders = req.headers["access-control-request-headers"];
    res.setHeader("Access-Control-Allow-Headers", requestHeaders ? requestHeaders : "*");
    res.setHeader("Access-Control-Allow-Origin", "*");
    if (req.method === "OPTIONS") {
        res.status(204).end();
    }
    else {
        next();
    }
};
exports.setHeadersMiddleware = setHeadersMiddleware;
