"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const orderform_controller_1 = require("../../../controllers/v1/orderform.controller");
const token_auth_1 = __importDefault(require("../../../middlewares/token.auth"));
const router = express_1.default.Router();
router.get("/", token_auth_1.default, orderform_controller_1.orderFormList);
router.post("/", token_auth_1.default, orderform_controller_1.orderFormDetail);
router.post("/finish-delivery", token_auth_1.default, orderform_controller_1.finishDelivery);
router.post("/release-order", token_auth_1.default, orderform_controller_1.releaseOrder);
router.patch("/release-order", token_auth_1.default, orderform_controller_1.updateReleaseOrderStatus);
exports.default = router;
