"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const token_auth_1 = __importDefault(require("../../../middlewares/token.auth"));
const inventoryTransfer_controller_1 = require("../../../controllers/v1/inventoryTransfer.controller");
const router = express_1.default.Router();
router.post("/dispatch", token_auth_1.default, inventoryTransfer_controller_1.dispatchInventoryTransfer);
router.post("/receive", token_auth_1.default, inventoryTransfer_controller_1.receiveInventoryTransfer);
router.get("/outgoing", token_auth_1.default, inventoryTransfer_controller_1.inventoryTransferOutLists);
router.get("/incoming", token_auth_1.default, inventoryTransfer_controller_1.inventoryTransferInLists);
exports.default = router;
