"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const accounts_router_1 = __importDefault(require("./sub-routes/v1/accounts.router"));
const dashboard_router_1 = __importDefault(require("./sub-routes/v1/dashboard.router"));
const orderform_router_1 = __importDefault(require("./sub-routes/v1/orderform.router"));
const location_router_1 = __importDefault(require("./sub-routes/v1/location.router"));
const media_router_1 = __importDefault(require("./sub-routes/v1/media.router"));
const deliveryreceipts_router_1 = __importDefault(require("./sub-routes/v1/deliveryreceipts.router"));
const version_1 = require("../util/version");
const inventoryTransfer_router_1 = __importDefault(require("./sub-routes/v1/inventoryTransfer.router"));
const router = express_1.default.Router();
router.get("/version", version_1.versioning);
router.use("/accounts", accounts_router_1.default);
router.use("/dashboard", dashboard_router_1.default);
router.use("/order-form", orderform_router_1.default);
router.use("/location", location_router_1.default);
router.use("/media", media_router_1.default);
router.use("/delivery-receipts", deliveryreceipts_router_1.default);
router.use("/inventory-transfer", inventoryTransfer_router_1.default);
exports.default = router;
