"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InventoryTransfer = void 0;
const sequelize_typescript_1 = require("sequelize-typescript");
const db_1 = __importDefault(require("../connection/db"));
const SellersCompany_model_1 = __importDefault(require("./SellersCompany.model"));
const Products_model_1 = __importDefault(require("./Products.model"));
let InventoryTransfer = class InventoryTransfer extends sequelize_typescript_1.Model {
};
exports.InventoryTransfer = InventoryTransfer;
__decorate([
    sequelize_typescript_1.PrimaryKey,
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.BIGINT),
    __metadata("design:type", typeof BigInt === "function" ? BigInt : Object)
], InventoryTransfer.prototype, "id", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.BIGINT),
    __metadata("design:type", typeof BigInt === "function" ? BigInt : Object)
], InventoryTransfer.prototype, "source_seller_id", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.BIGINT),
    __metadata("design:type", typeof BigInt === "function" ? BigInt : Object)
], InventoryTransfer.prototype, "target_seller_id", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.BIGINT),
    __metadata("design:type", typeof BigInt === "function" ? BigInt : Object)
], InventoryTransfer.prototype, "source_product_id", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.BIGINT),
    __metadata("design:type", typeof BigInt === "function" ? BigInt : Object)
], InventoryTransfer.prototype, "target_product_id", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.INTEGER),
    __metadata("design:type", Number)
], InventoryTransfer.prototype, "quantity", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.STRING),
    __metadata("design:type", String)
], InventoryTransfer.prototype, "approval_status", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.BIGINT),
    __metadata("design:type", String)
], InventoryTransfer.prototype, "warehouse_transferred_out_initiator", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.BIGINT),
    __metadata("design:type", String)
], InventoryTransfer.prototype, "warehouse_transferred_in_initiator", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.BOOLEAN),
    __metadata("design:type", Boolean)
], InventoryTransfer.prototype, "warehouse_transferred_out_status", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.BOOLEAN),
    __metadata("design:type", Boolean)
], InventoryTransfer.prototype, "warehouse_transferred_in_status", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.STRING),
    __metadata("design:type", String)
], InventoryTransfer.prototype, "warehouse_transferred_out_attachment", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.STRING),
    __metadata("design:type", String)
], InventoryTransfer.prototype, "warehouse_transferred_in_attachment", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.STRING),
    __metadata("design:type", String)
], InventoryTransfer.prototype, "created_by", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)(sequelize_typescript_1.DataType.STRING),
    __metadata("design:type", String)
], InventoryTransfer.prototype, "approved_by", void 0);
exports.InventoryTransfer = InventoryTransfer = __decorate([
    (0, sequelize_typescript_1.Table)({
        timestamps: true,
        tableName: "inventory_transfer",
    })
], InventoryTransfer);
db_1.default.addModels([InventoryTransfer]);
InventoryTransfer.belongsTo(SellersCompany_model_1.default, {
    foreignKey: "source_seller_id",
    as: "source_seller",
});
InventoryTransfer.belongsTo(SellersCompany_model_1.default, {
    foreignKey: "target_seller_id",
    as: "target_seller",
});
InventoryTransfer.belongsTo(Products_model_1.default, {
    foreignKey: "source_product_id",
    as: "source_product",
});
InventoryTransfer.belongsTo(Products_model_1.default, {
    foreignKey: "target_product_id",
    as: "target_product",
});
exports.default = InventoryTransfer;
