"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const dotenv_1 = __importDefault(require("dotenv"));
const Drivers_model_1 = __importDefault(require("../models/Drivers.model"));
const Sellers_model_1 = __importDefault(require("../models/Sellers.model"));
const errors_1 = require("../util/errors");
dotenv_1.default.config();
const authorizationTokenMiddleware = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const authHeader = req.get("Authorization");
        if (!authHeader) {
            res.status(401).json(errors_1.errors.UNAUTHENTICATED);
            return;
        }
        const token = authHeader === null || authHeader === void 0 ? void 0 : authHeader.split(" ")[1];
        const decodedToken = jsonwebtoken_1.default.verify(token, process.env.SECRETKEY);
        if (!decodedToken) {
            res.status(401).json(errors_1.errors.UNAUTHENTICATED);
            return;
        }
        const isDriver = (decodedToken === null || decodedToken === void 0 ? void 0 : decodedToken.isDriverToken) === true;
        if (isDriver) {
            const driver = yield Drivers_model_1.default.findByPk(decodedToken.id);
            if (!driver) {
                res.status(401).json(errors_1.errors.INVALID_TOKEN);
                return;
            }
        }
        else {
            const seller = yield Sellers_model_1.default.findByPk(decodedToken.id);
            if (!seller) {
                res.status(401).json(errors_1.errors.INVALID_TOKEN);
                return;
            }
        }
        req.userDetail = {
            id: decodedToken.id,
            parent_id: decodedToken.parent_id,
            isDriver: isDriver,
        };
        next();
    }
    catch (err) {
        console.error(err);
        next(err);
    }
});
exports.default = authorizationTokenMiddleware;
