"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateReleaseOrderStatus = exports.releaseOrder = exports.finishDelivery = exports.orderFormDetail = exports.orderFormList = void 0;
const errors_1 = require("../../util/errors");
const OrderForm_model_1 = __importDefault(require("../../models/OrderForm.model"));
const OrderFormDetails_model_1 = __importDefault(require("../../models/OrderFormDetails.model"));
const Products_model_1 = __importDefault(require("../../models/Products.model"));
const MultipleDeliveryReceipts_model_1 = __importDefault(require("../../models/MultipleDeliveryReceipts.model"));
const sequelize_1 = require("sequelize");
const catchAsync_1 = __importDefault(require("../../util/catchAsync"));
const Customers_model_1 = __importDefault(require("../../models/Customers.model"));
exports.orderFormList = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const page = parseInt(req.query.page || "1", 10);
    const limit = parseInt(req.query.limit || "10", 10);
    const offset = (page - 1) * limit;
    const filter = req.query.statusFilter;
    const keyword = req.query.keyword;
    const expiredRo = req.query.expiredRo;
    let statusFilter = "Delivered";
    switch (filter) {
        case "fd":
            statusFilter = "For Delivery - Warehouse";
            break;
        case "d":
            statusFilter = "Delivered";
            break;
        case "rocp":
            statusFilter = {
                [sequelize_1.Op.or]: ["Release Order- Customer Pickup", "Release Order - Customer Pickup"],
            };
            break;
        case "sfd":
            statusFilter = "For Delivery";
            break;
        case "r":
            statusFilter = "Received";
            break;
        case "rod":
            statusFilter = "Release Order - Delivery";
            break;
        default:
            statusFilter = "Delivered";
            break;
    }
    const whereClause = {
        reference_no: {
            [sequelize_1.Op.like]: `%${keyword}%`,
        },
        status: statusFilter,
        isExpiredRO: expiredRo === "true" ? 1 : 0,
    };
    if (userDetail && userDetail.isDriver) {
        whereClause.driver = userDetail.id;
    }
    else {
        whereClause.seller_id = userDetail === null || userDetail === void 0 ? void 0 : userDetail.parent_id;
    }
    const orders = yield OrderForm_model_1.default.findAndCountAll({
        where: whereClause,
        limit,
        offset,
        order: [["date_created", "DESC"]],
        include: [{
                model: Customers_model_1.default,
                as: "customer"
            }]
    });
    const { rows, count } = orders;
    const responseJson = rows.map((order) => {
        var _a;
        return ({
            id: order.id,
            reference_no: order.reference_no,
            customer: {
                name: order.name,
                address: order.address,
                contact_number: order.contact_number,
                email_address: order.email,
                hardware_name: (_a = order.customer) === null || _a === void 0 ? void 0 : _a.hardware_name
            },
            ro_number: order.release_order_number,
            timestamp: filter === "fd" ? order.dateTime_for_delivery : order.date_delivered,
        });
    });
    const totalPages = Math.ceil(count / limit);
    res.status(200).json({
        success: true,
        response: responseJson,
        pagination: {
            page,
            limit,
            total_pages: totalPages,
            has_next_page: page < totalPages,
        },
    });
}));
exports.orderFormDetail = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const { reference_no, asset_folder = "delivery" } = req.body;
    const whereClause = {
        reference_no,
    };
    if (userDetail && userDetail.isDriver) {
        whereClause.driver = userDetail.id;
    }
    else {
        whereClause.seller_id = userDetail === null || userDetail === void 0 ? void 0 : userDetail.parent_id;
    }
    const assetUrl = `https://buildhub.ph/${asset_folder === "delivery" ? "img/delivery/" : "uploads/"}`;
    const orderFormWithDetail = (yield OrderForm_model_1.default.findOne({
        where: whereClause,
        include: [
            {
                model: OrderFormDetails_model_1.default,
                as: "order_form_details",
                include: [
                    {
                        model: Products_model_1.default,
                        as: "product",
                    },
                ],
            },
            {
                model: MultipleDeliveryReceipts_model_1.default,
                as: "multiple_delivery_receipts",
            },
            {
                model: Customers_model_1.default,
                as: "customer"
            }
        ],
    }));
    if (!orderFormWithDetail) {
        res.status(404).json(errors_1.errors.INVALID_REFERENCE_NO);
        return;
    }
    const modifiedResponseJson = {
        id: orderFormWithDetail.id,
        reference_no: orderFormWithDetail.reference_no,
        status: orderFormWithDetail.status,
        shipping: orderFormWithDetail.shipping_type,
        customer: {
            id: orderFormWithDetail.customer_id,
            name: orderFormWithDetail.name,
            email: orderFormWithDetail.email,
            contact_number: orderFormWithDetail.contact_number,
            address: orderFormWithDetail.address,
            longitude: orderFormWithDetail.longitude,
            latitude: orderFormWithDetail.latitude,
            hardware_name: orderFormWithDetail.customer.hardware_name
        },
        for_delivery_timestamp: orderFormWithDetail.dateTime_for_delivery,
        delivered_timestamp: orderFormWithDetail.date_delivered,
        created_timestamp: orderFormWithDetail.date_created,
        release_order_image: orderFormWithDetail.release_order_image &&
            orderFormWithDetail.release_order_image !== null &&
            orderFormWithDetail.release_order_image !== ""
            ? `https://buildhub.ph/uploads/${orderFormWithDetail.release_order_image}`
            : null,
        po_attachment_image: orderFormWithDetail.po_attachment &&
            orderFormWithDetail.po_attachment !== null &&
            orderFormWithDetail.po_attachment !== ""
            ? `https://api.buildhubware.com/public/orderform/note/${orderFormWithDetail.po_attachment}`
            : null,
        ro_number: orderFormWithDetail.release_order_number,
        order_total_amount: orderFormWithDetail.total_amount,
        order_form_details: orderFormWithDetail.order_form_details.map((order_form_detail) => ({
            product_name: order_form_detail.product ? order_form_detail.product.menu : null,
            photo: order_form_detail.product &&
                order_form_detail.product.photo &&
                order_form_detail.product.photo !== null &&
                order_form_detail.product.photo !== ""
                ? order_form_detail.product.seller_dashboard_src
                    ? `https://api.buildhubware.com/public/products/${order_form_detail.product.photo}`
                    : `https://buildhub.ph/img/products/${order_form_detail.product.photo}`
                : null,
            quantity: order_form_detail.quantity,
            price: order_form_detail.price,
            amount: order_form_detail.amount,
        })),
        delivery_receipts: orderFormWithDetail.multiple_delivery_receipts &&
            Array.isArray(orderFormWithDetail.multiple_delivery_receipts) &&
            orderFormWithDetail.multiple_delivery_receipts.length > 0
            ? orderFormWithDetail.multiple_delivery_receipts.map((deliveryReceipt) => ({
                id: deliveryReceipt.id,
                photo: deliveryReceipt.delivered_picture &&
                    deliveryReceipt.delivered_picture !== null &&
                    deliveryReceipt.delivered_picture !== ""
                    ? `${assetUrl}${deliveryReceipt.delivered_picture}`
                    : null,
                timestamp: deliveryReceipt.date_created,
            }))
            : [],
        truck_id: orderFormWithDetail.truck
    };
    res.status(200).json({ success: true, response: modifiedResponseJson });
}));
exports.finishDelivery = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const { reference_no, file_names } = req.body;
    const whereClause = {
        reference_no,
    };
    let newOrderStatus = "";
    if (userDetail && userDetail.isDriver) {
        whereClause.driver = userDetail.id;
        whereClause.status = "For Delivery - Warehouse";
        newOrderStatus = "Delivered";
    }
    else {
        whereClause.seller_id = userDetail === null || userDetail === void 0 ? void 0 : userDetail.parent_id;
        newOrderStatus = "Received";
        whereClause.status = {
            [sequelize_1.Op.or]: ["Release Order- Customer Pickup", "Release Order - Delivery", "Release Order - Customer Pickup"],
        };
    }
    const orderForm = yield OrderForm_model_1.default.findOne({
        where: whereClause,
    });
    if (!orderForm) {
        res.status(400).json(errors_1.errors.INVALID_REFERENCE_NO);
        return;
    }
    if (!file_names || !Array.isArray(file_names) || file_names.length === 0) {
        res.status(400).json(errors_1.errors.INVALID_REQUEST_TYPE);
        return;
    }
    if (orderForm.status === "Release Order - Delivery") {
        newOrderStatus = "Delivered";
    }
    orderForm.status = newOrderStatus;
    orderForm.date_delivered = new Date();
    const multipleDeliveryReceiptsArray = file_names.map((fileName) => ({
        reference_no,
        driver: userDetail === null || userDetail === void 0 ? void 0 : userDetail.id,
        delivered_picture: fileName,
        date_created: new Date(),
    }));
    const orderFormUpdatePromise = orderForm.save();
    const multipleDeliveryReceiptsPromise = MultipleDeliveryReceipts_model_1.default.bulkCreate(multipleDeliveryReceiptsArray);
    yield Promise.all([orderFormUpdatePromise, multipleDeliveryReceiptsPromise]);
    res.status(201).json({ success: true });
}));
exports.releaseOrder = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const { reference_no, file_names } = req.body;
    const whereClause = {
        reference_no,
        seller_id: userDetail === null || userDetail === void 0 ? void 0 : userDetail.parent_id,
    };
    const orderForm = yield OrderForm_model_1.default.findOne({
        where: whereClause,
    });
    if (!orderForm) {
        res.status(400).json(errors_1.errors.INVALID_REFERENCE_NO);
        return;
    }
    if (!file_names || !Array.isArray(file_names) || file_names.length === 0) {
        res.status(400).json(errors_1.errors.INVALID_REQUEST_TYPE);
        return;
    }
    orderForm.status = "For Delivery - Warehouse";
    const multipleDeliveryReceiptsArray = file_names.map((fileName) => ({
        reference_no,
        delivered_picture: fileName,
        date_created: new Date(),
    }));
    const orderFormUpdatePromise = orderForm.save();
    const multipleDeliveryReceiptsPromise = MultipleDeliveryReceipts_model_1.default.bulkCreate(multipleDeliveryReceiptsArray);
    yield Promise.all([orderFormUpdatePromise, multipleDeliveryReceiptsPromise]);
    res.status(201).json({ success: true });
}));
exports.updateReleaseOrderStatus = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const { reference_no, roStatus = true } = req.body;
    yield OrderForm_model_1.default.update({
        isExpiredRO: roStatus === true ? 1 : 0,
    }, {
        where: {
            seller_id: userDetail === null || userDetail === void 0 ? void 0 : userDetail.parent_id,
            reference_no: reference_no,
        },
    });
    res.status(200).json({ success: true });
}));
