"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateMedia = exports.uploadMedia = void 0;
const errors_1 = require("../../util/errors");
const MultipleDeliveryReceipts_model_1 = __importDefault(require("../../models/MultipleDeliveryReceipts.model"));
const catchAsync_1 = __importDefault(require("../../util/catchAsync"));
exports.uploadMedia = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const files = req.files;
    const driverAttachment = files["file_media"];
    const { asset_folder } = req.query;
    if (!driverAttachment && !Array.isArray(driverAttachment)) {
        res.status(400).json(errors_1.errors.INVALID_REQUEST_BODY);
        return;
    }
    const mediaResponseJson = {
        raw: driverAttachment[0].filename,
        url: `${asset_folder === "delivery"
            ? `https://buildhub.ph/img/delivery/${driverAttachment[0].filename}`
            : `https://buildhub.ph/uploads/${driverAttachment[0].filename}`}`,
    };
    res.status(201).json({ success: true, response: mediaResponseJson });
}));
exports.updateMedia = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const files = req.files;
    const driverAttachment = files["file_media"];
    const { id } = req.params;
    const { asset_folder } = req.query;
    if ((!driverAttachment && !Array.isArray(driverAttachment)) || !id) {
        res.status(400).json(errors_1.errors.INVALID_REQUEST_BODY);
        return;
    }
    const multipleDeliveryReceipt = yield MultipleDeliveryReceipts_model_1.default.findOne({
        where: {
            id,
        },
    });
    if (!multipleDeliveryReceipt) {
        res.status(400).json(errors_1.errors.INVALID_ID);
        return;
    }
    multipleDeliveryReceipt.delivered_picture = driverAttachment[0].filename;
    yield multipleDeliveryReceipt.save();
    const mediaResponseJson = {
        raw: driverAttachment[0].filename,
        url: `${asset_folder === "delivery"
            ? `https://buildhub.ph/img/delivery/${driverAttachment[0].filename}`
            : `https://buildhub.ph/uploads/${driverAttachment[0].filename}`}`,
    };
    res.status(200).json({ success: true, response: mediaResponseJson });
}));
