"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendOrderLocation = void 0;
const errors_1 = require("../../util/errors");
const Location_model_1 = __importDefault(require("../../models/Location.model"));
const catchAsync_1 = __importDefault(require("../../util/catchAsync"));
exports.sendOrderLocation = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const { vehicle_id, latitude, longitude, order_id } = req.body;
    if (!vehicle_id || !order_id || !longitude || !latitude) {
        res.status(400).json(errors_1.errors.INVALID_REQUEST_BODY);
        return;
    }
    const currentTime = new Date().toLocaleTimeString("en-US", {
        hour12: false,
        timeZone: "Asia/Manila",
    });
    const location = yield Location_model_1.default.create({
        vehicle_id,
        order_id,
        date: new Date(),
        time: currentTime,
        longtitude: longitude,
        latitude,
    });
    res.status(201).json({ success: true, response: location });
}));
