"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.inventoryTransferInLists = exports.inventoryTransferOutLists = exports.receiveInventoryTransfer = exports.dispatchInventoryTransfer = void 0;
const errors_1 = require("../../util/errors");
const catchAsync_1 = __importDefault(require("../../util/catchAsync"));
const InventoryTransfer_model_1 = require("../../models/InventoryTransfer.model");
const SellersCompany_model_1 = __importDefault(require("../../models/SellersCompany.model"));
const Products_model_1 = __importDefault(require("../../models/Products.model"));
const InventoryTransferDetails_model_1 = __importDefault(require("../../models/InventoryTransferDetails.model"));
exports.dispatchInventoryTransfer = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const { id, file_name } = req.body;
    if (!id || !file_name) {
        res.status(400).json(errors_1.errors.INVALID_REQUEST_TYPE);
        return;
    }
    const whereClause = {
        id: id,
        source_seller_id: userDetail === null || userDetail === void 0 ? void 0 : userDetail.parent_id,
        approval_status: "Approved",
        warehouse_transferred_out_status: false,
    };
    const inventoryTransfer = yield InventoryTransfer_model_1.InventoryTransfer.findOne({
        where: whereClause,
    });
    if (!inventoryTransfer) {
        res.status(404).json(errors_1.errors.RECORD_NOT_FOUND);
        return;
    }
    inventoryTransfer.warehouse_transferred_out_status = true;
    inventoryTransfer.warehouse_transferred_out_initiator = userDetail === null || userDetail === void 0 ? void 0 : userDetail.id;
    inventoryTransfer.warehouse_transferred_out_attachment = file_name;
    yield inventoryTransfer.save();
    res.status(200).json({ success: true });
}));
exports.receiveInventoryTransfer = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const { id, file_name } = req.body;
    if (!id || !file_name) {
        res.status(400).json(errors_1.errors.INVALID_REQUEST_TYPE);
        return;
    }
    const whereClause = {
        id: id,
        target_seller_id: userDetail === null || userDetail === void 0 ? void 0 : userDetail.parent_id,
        approval_status: "Approved",
        warehouse_transferred_out_status: true,
        warehouse_transferred_in_status: false
    };
    const inventoryTransfer = yield InventoryTransfer_model_1.InventoryTransfer.findOne({
        where: whereClause,
    });
    if (!inventoryTransfer) {
        res.status(404).json(errors_1.errors.RECORD_NOT_FOUND);
        return;
    }
    inventoryTransfer.warehouse_transferred_in_status = true;
    inventoryTransfer.warehouse_transferred_in_initiator = userDetail === null || userDetail === void 0 ? void 0 : userDetail.id;
    inventoryTransfer.warehouse_transferred_in_attachment = file_name;
    yield inventoryTransfer.save();
    res.status(200).json({ success: true });
}));
exports.inventoryTransferOutLists = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const whereClause = {
        source_seller_id: userDetail === null || userDetail === void 0 ? void 0 : userDetail.parent_id,
        approval_status: "Approved",
        warehouse_transferred_out_status: false,
        warehouse_transferred_in_status: false,
    };
    const inventoryTransfers = yield InventoryTransfer_model_1.InventoryTransfer.findAll({
        where: whereClause,
        attributes: [
            "id",
            "quantity",
            "createdAt",
            "updatedAt",
            "approval_status",
        ],
        include: [
            {
                model: SellersCompany_model_1.default,
                as: "target_seller",
                attributes: ["id", "company_name"],
            },
            {
                model: Products_model_1.default,
                as: "source_product",
                attributes: ["id", "menu", "photo", "seller_dashboard_src"],
            },
            {
                model: Products_model_1.default,
                as: "target_product",
                attributes: ["id", "menu", "photo", "seller_dashboard_src"],
            },
            {
                model: InventoryTransferDetails_model_1.default,
                as: "inventory_transfer_details",
                attributes: [
                    "id",
                    "source_product_id",
                    "target_product_id",
                    "quantity",
                ],
                include: [
                    {
                        model: Products_model_1.default,
                        as: "source_product",
                        attributes: ["id", "menu", "photo", "seller_dashboard_src"],
                    },
                    {
                        model: Products_model_1.default,
                        as: "target_product",
                        attributes: ["id", "menu", "photo", "seller_dashboard_src"],
                    },
                ],
            },
        ],
    });
    const mappedInventoryTransfers = inventoryTransfers.map((transfer) => {
        var _a, _b, _c, _d;
        const productSources = [];
        if (transfer.source_product && transfer.target_product) {
            const sourceProductPhoto = ((_a = transfer.source_product) === null || _a === void 0 ? void 0 : _a.photo) || null;
            const targetProductPhoto = ((_b = transfer.target_product) === null || _b === void 0 ? void 0 : _b.photo) || null;
            const sourceProductImage = sourceProductPhoto !== null
                ? ((_c = transfer.source_product) === null || _c === void 0 ? void 0 : _c.seller_dashboard_src)
                    ? `https://api.buildhubware.com/public/products/${sourceProductPhoto}`
                    : `https://buildhub.ph/img/products/${sourceProductPhoto}`
                : null;
            const targetProductImage = targetProductPhoto !== null
                ? ((_d = transfer.target_product) === null || _d === void 0 ? void 0 : _d.seller_dashboard_src)
                    ? `https://api.buildhubware.com/public/products/${targetProductPhoto}`
                    : `https://buildhub.ph/img/products/${targetProductPhoto}`
                : null;
            if (transfer.source_product) {
                transfer.source_product.photo = sourceProductImage;
            }
            if (transfer.target_product) {
                transfer.target_product.photo = targetProductImage;
            }
            productSources.push({
                source_product: transfer.source_product,
                target_product: transfer.target_product,
                quantity: transfer.quantity,
            });
        }
        if (transfer.inventory_transfer_details &&
            transfer.inventory_transfer_details.length > 0) {
            transfer.inventory_transfer_details.forEach((detail) => {
                var _a, _b, _c, _d;
                const sourceProductPhoto = ((_a = detail.source_product) === null || _a === void 0 ? void 0 : _a.photo) || null;
                const targetProductPhoto = ((_b = detail.target_product) === null || _b === void 0 ? void 0 : _b.photo) || null;
                const sourceProductImage = sourceProductPhoto !== null
                    ? ((_c = detail.source_product) === null || _c === void 0 ? void 0 : _c.seller_dashboard_src)
                        ? `https://api.buildhubware.com/public/products/${sourceProductPhoto}`
                        : `https://buildhub.ph/img/products/${sourceProductPhoto}`
                    : null;
                const targetProductImage = targetProductPhoto !== null
                    ? ((_d = detail.target_product) === null || _d === void 0 ? void 0 : _d.seller_dashboard_src)
                        ? `https://api.buildhubware.com/public/products/${targetProductPhoto}`
                        : `https://buildhub.ph/img/products/${targetProductPhoto}`
                    : null;
                if (detail.source_product) {
                    detail.source_product.photo = sourceProductImage;
                }
                if (detail.target_product) {
                    detail.target_product.photo = targetProductImage;
                }
                productSources.push({
                    source_product: detail.source_product,
                    target_product: detail.target_product,
                    quantity: detail.quantity,
                });
            });
        }
        return {
            id: transfer.id,
            quantity: parseFloat(transfer.quantity),
            createdAt: transfer.createdAt,
            updatedAt: transfer.updatedAt,
            approval_status: transfer.approval_status,
            target_seller: transfer.target_seller,
            products: productSources,
        };
    });
    res.status(200).json({ success: true, data: mappedInventoryTransfers });
}));
exports.inventoryTransferInLists = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const whereClause = {
        target_seller_id: userDetail === null || userDetail === void 0 ? void 0 : userDetail.parent_id,
        approval_status: "Approved",
        warehouse_transferred_in_status: false,
        warehouse_transferred_out_status: true,
    };
    const inventoryTransfers = yield InventoryTransfer_model_1.InventoryTransfer.findAll({
        where: whereClause,
        include: [
            {
                model: SellersCompany_model_1.default,
                as: "source_seller",
                attributes: ["id", "company_name"],
            },
            {
                model: Products_model_1.default,
                as: "source_product",
                attributes: ["id", "menu", "photo", "seller_dashboard_src"],
            },
            {
                model: Products_model_1.default,
                as: "target_product",
                attributes: ["id", "menu", "photo", "seller_dashboard_src"],
            },
            {
                model: InventoryTransferDetails_model_1.default,
                as: "inventory_transfer_details",
                attributes: [
                    "id",
                    "source_product_id",
                    "target_product_id",
                    "quantity",
                ],
                include: [
                    {
                        model: Products_model_1.default,
                        as: "source_product",
                        attributes: ["id", "menu", "photo", "seller_dashboard_src"],
                    },
                    {
                        model: Products_model_1.default,
                        as: "target_product",
                        attributes: ["id", "menu", "photo", "seller_dashboard_src"],
                    },
                ],
            },
        ],
    });
    const mappedInventoryTransfers = inventoryTransfers.map((transfer) => {
        var _a, _b, _c, _d;
        const productSources = [];
        if (transfer.source_product && transfer.target_product) {
            const sourceProductPhoto = ((_a = transfer.source_product) === null || _a === void 0 ? void 0 : _a.photo) || null;
            const targetProductPhoto = ((_b = transfer.target_product) === null || _b === void 0 ? void 0 : _b.photo) || null;
            const sourceProductImage = sourceProductPhoto !== null
                ? ((_c = transfer.source_product) === null || _c === void 0 ? void 0 : _c.seller_dashboard_src)
                    ? `https://api.buildhubware.com/public/products/${sourceProductPhoto}`
                    : `https://buildhub.ph/img/products/${sourceProductPhoto}`
                : null;
            const targetProductImage = targetProductPhoto !== null
                ? ((_d = transfer.target_product) === null || _d === void 0 ? void 0 : _d.seller_dashboard_src)
                    ? `https://api.buildhubware.com/public/products/${targetProductPhoto}`
                    : `https://buildhub.ph/img/products/${targetProductPhoto}`
                : null;
            if (transfer.source_product) {
                transfer.source_product.photo = sourceProductImage;
            }
            if (transfer.target_product) {
                transfer.target_product.photo = targetProductImage;
            }
            productSources.push({
                source_product: transfer.source_product,
                target_product: transfer.target_product,
                quantity: transfer.quantity,
            });
        }
        if (transfer.inventory_transfer_details &&
            transfer.inventory_transfer_details.length > 0) {
            transfer.inventory_transfer_details.forEach((detail) => {
                var _a, _b, _c, _d;
                const sourceProductPhoto = ((_a = detail.source_product) === null || _a === void 0 ? void 0 : _a.photo) || null;
                const targetProductPhoto = ((_b = detail.target_product) === null || _b === void 0 ? void 0 : _b.photo) || null;
                const sourceProductImage = sourceProductPhoto !== null
                    ? ((_c = detail.source_product) === null || _c === void 0 ? void 0 : _c.seller_dashboard_src)
                        ? `https://api.buildhubware.com/public/products/${sourceProductPhoto}`
                        : `https://buildhub.ph/img/products/${sourceProductPhoto}`
                    : null;
                const targetProductImage = targetProductPhoto !== null
                    ? ((_d = detail.target_product) === null || _d === void 0 ? void 0 : _d.seller_dashboard_src)
                        ? `https://api.buildhubware.com/public/products/${targetProductPhoto}`
                        : `https://buildhub.ph/img/products/${targetProductPhoto}`
                    : null;
                if (detail.source_product) {
                    detail.source_product.photo = sourceProductImage;
                }
                if (detail.target_product) {
                    detail.target_product.photo = targetProductImage;
                }
                productSources.push({
                    source_product: detail.source_product,
                    target_product: detail.target_product,
                    quantity: detail.quantity,
                });
            });
        }
        return {
            id: transfer.id,
            quantity: parseFloat(transfer.quantity),
            createdAt: transfer.createdAt,
            updatedAt: transfer.updatedAt,
            approval_status: transfer.approval_status,
            source_seller: transfer.source_seller,
            products: productSources,
        };
    });
    res.status(200).json({ success: true, data: mappedInventoryTransfers });
}));
