"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.insertDeliveryReceipts = void 0;
const errors_1 = require("../../util/errors");
const MultipleDeliveryReceipts_model_1 = __importDefault(require("../../models/MultipleDeliveryReceipts.model"));
const catchAsync_1 = __importDefault(require("../../util/catchAsync"));
exports.insertDeliveryReceipts = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const { reference_no, file_names } = req.body;
    if (!file_names || !Array.isArray(file_names) || file_names.length === 0) {
        res.status(400).json(errors_1.errors.INVALID_REQUEST_TYPE);
        return;
    }
    const multipleDeliveryReceipts = file_names.map((fileName) => ({
        reference_no,
        delivered_picture: fileName,
        date_created: new Date(),
        driver: userDetail === null || userDetail === void 0 ? void 0 : userDetail.id,
    }));
    yield MultipleDeliveryReceipts_model_1.default.bulkCreate(multipleDeliveryReceipts);
    res.status(201).json({ success: true });
}));
