"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDashboardData = void 0;
const OrderForm_model_1 = __importDefault(require("../../models/OrderForm.model"));
const catchAsync_1 = __importDefault(require("../../util/catchAsync"));
exports.getDashboardData = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { userDetail } = req;
    const forDeliveryPromise = OrderForm_model_1.default.count({
        where: {
            status: "For Delivery - Warehouse",
            driver: userDetail === null || userDetail === void 0 ? void 0 : userDetail.id,
        },
    });
    const deliveredOrdersPromise = OrderForm_model_1.default.findAll({
        where: {
            status: "Delivered",
            driver: userDetail === null || userDetail === void 0 ? void 0 : userDetail.id,
        },
        order: [["date_created", "DESC"]],
    });
    const [forDeliveryCount, deliveredOrders] = yield Promise.all([forDeliveryPromise, deliveredOrdersPromise]);
    const response = {
        for_delivery_count: forDeliveryCount,
        delivered_orders_count: deliveredOrders.length,
        delivered_orders: deliveredOrders.map((order) => order.reference_no),
    };
    res.status(200).json({ success: true, response });
}));
