"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.warehousemanLogin = exports.driverLogin = void 0;
const Drivers_model_1 = __importDefault(require("../../models/Drivers.model"));
const errors_1 = require("../../util/errors");
const token_1 = require("../../util/token");
const Sellers_model_1 = __importDefault(require("../../models/Sellers.model"));
const catchAsync_1 = __importDefault(require("../../util/catchAsync"));
const SellersCompany_model_1 = __importDefault(require("../../models/SellersCompany.model"));
const sequelize_1 = require("sequelize");
exports.driverLogin = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { username, password } = req.body;
    if (!username || !password) {
        res.status(400).json(errors_1.errors.INVALID_LOGIN);
        return;
    }
    const driver = yield Drivers_model_1.default.findOne({
        where: {
            username,
            password,
        },
    });
    if (!driver) {
        res.status(400).json(errors_1.errors.INVALID_LOGIN);
        return;
    }
    const token = (0, token_1.generateToken)(driver);
    res.status(200).json({
        success: true,
        token,
        driver: {
            id: driver.id,
            name: driver.name,
            address: driver.address,
            phone_number: driver.phone_number,
        },
    });
}));
exports.warehousemanLogin = (0, catchAsync_1.default)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { username, password } = req.body;
    if (!username || !password) {
        res.status(400).json(errors_1.errors.INVALID_LOGIN);
        return;
    }
    const seller = yield Sellers_model_1.default.findOne({
        where: {
            username,
            password,
            [sequelize_1.Op.or]: [{ isAuthorizedWarehouse: "Yes" }, { is_guard: true }],
        },
    });
    if (!seller) {
        res.status(400).json(errors_1.errors.INVALID_LOGIN);
        return;
    }
    const sellerCompany = yield SellersCompany_model_1.default.findOne({
        where: {
            id: seller.seller_id,
        },
    });
    const token = (0, token_1.generateToken)(seller, false);
    res.status(200).json({
        success: true,
        token,
        seller: {
            id: seller.id,
            seller_id: seller.seller_id,
            name: seller.name,
            address: seller.address,
            is_visible_price: sellerCompany === null || sellerCompany === void 0 ? void 0 : sellerCompany.display_price_in_releasing,
            is_guard: (seller === null || seller === void 0 ? void 0 : seller.is_guard) || false,
        },
    });
}));
