"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const dotenv_1 = __importDefault(require("dotenv"));
const body_parser_1 = __importDefault(require("body-parser"));
const morgan_1 = __importDefault(require("morgan"));
const db_1 = __importDefault(require("./connection/db"));
const main_router_1 = __importDefault(require("./routes/main.router"));
const assets_router_1 = __importDefault(require("./routes/assets.router"));
const logger_1 = __importDefault(require("./util/logger"));
const cors_1 = require("./util/cors");
const multer_1 = require("./util/multer");
dotenv_1.default.config();
const app = (0, express_1.default)();
app.use((0, morgan_1.default)("tiny"));
app.use(body_parser_1.default.json());
app.use(multer_1.multerConfiguration);
app.use(cors_1.setHeadersMiddleware);
app.use("/api/v1", main_router_1.default);
app.use("/assets/", assets_router_1.default);
app.use("*", (req, res, next) => {
    res.status(404).json({ success: false, message: "Resource unavailable." });
});
app.use((error, req, res, next) => {
    console.log(error);
    const status = error.statusCode || 500;
    const message = error.message;
    const data = error.data;
    logger_1.default.error(`Status: ${status}, Message: ${message}, Data: ${JSON.stringify(data)}, Stack: ${error.stack}`);
    res.status(status).json({ success: false, message: "Please try again later." });
});
const port = process.env.PORT || 3000;
db_1.default
    .authenticate()
    .then(() => {
    console.log("Database connected...");
    return db_1.default.sync();
})
    .then(() => {
    app.listen(port, () => {
        console.log(`Server is running on port ${port}`);
    });
})
    .catch((err) => {
    throw err;
});
